



export class ErrorReportWidget {
	
	tpl = `
		<div class="page-header">
			<h1>Error</h1>
		</div>
		
		<div [contentHTML]="errorMessage"></div>
	`;
	
	
	init( e, opts ) {
		
		console.error( e, opts );
		
		let msg;
		
		if (typeof opts.error == 'string')
			msg = opts.error;
		else
			msg = opts.error.message;
		
		let ezTpl = new EzTemplate( e );
		ezTpl.loadHtml( this.tpl );
		
		if (opts.error.stack) {
			msg += '<hr/><pre>' + opts.error.stack + '</pre>';
		}
		ezTpl.setVar('errorMessage', msg);
		
		ezTpl.render();
		
	}
	
}

